// // // // // // // // // // // // //
//
//	AVLTree.h
//
//	created April/28/98 by Andreas Warnke
//	modified April/28/98 by Andreas Warnke
//



#ifndef AVL_TREE_H_
#define AVL_TREE_H_



// // // // // // // // // // // // //
//
//	include
//

class AVLNode;
#include "AVLNode.h"



// // // // // // // // // // // // //
//
//	class AVLTree
//

class AVLTree
{
private:
	//	root:
	AVLNode * TheRoot;
	
	//	Number of nodes:
	unsigned int TheCount;
	
private:
	//	Insert in subtree, returns true <=> subtree grew
	static bool InsertInSubtree (
		AVLNode ** ioRoot,
		AVLNode * inNode,
		AVLTree * inTree );
	
	//	Remove:
	//	these functions return, if the tree is shrunk.
	static bool RemoveNodeFromSubTree (
		AVLNode ** ioRoot,
		int inKey,
		AVLNode * inNode,
		bool inIgnoreKeyAndRemoveLeft,
		AVLNode ** outFound );
	static bool RemoveRoot (
		AVLNode ** ioRoot );
	static bool RotateAfterRemove (
		AVLNode ** ioRoot );
	
	//	Rotations:
	static void RotateLeft ( AVLNode ** ioRoot );
	static void RotateRight ( AVLNode ** ioRoot );
	static void RotateLeftRight ( AVLNode ** ioRoot );
	static void RotateRightLeft ( AVLNode ** ioRoot );
	
	//	CrashSubTree, called by MakeEmpty()
	static void CrashSubTree ( AVLNode * inRoot, bool inDelete );
	
	//	debug:
	void cout_tree ( AVLNode * inRoot, int inLevel = 0 );
	
public:
	//	Constructors:
	AVLTree ();
	
	//	Destructor:
	virtual ~AVLTree ();
	
	//	Insert:
	//	returns false <=> inNode is already in a tree
	bool Insert ( AVLNode * inNode );
	
	//	Remove:
	//	returns false <=> inNode was not in the tree
	bool Remove ( AVLNode * inNode );
	AVLNode * Remove ( int inKey, bool inAll = false );
	
	//	Find:
	AVLNode * Find ( int inKey );
	
	//	MakeEmpty:
	void MakeEmpty ( bool inDelete = false );
	
	//	CountNodes:
	unsigned int CountNodes ();
};



#endif



//
//	The End
//
// // // // // // // // // // // // //